<?php
/**
 * Plugin Name: WPSyncSheets For Elementor
 * Plugin URI: https://www.wpsyncsheets.com/wpsyncsheets-for-elementor/
 * Description: Save all Elementor Pro Form entries within one google spreadsheet.
 * Version: 4.2
 * Author: Creative Werk Designs
 * Author URI: https://www.creativewerkdesigns.com/
 * Text Domain: wpsse
 * Domain Path: /languages
 * Requires at least: 5.3
 * Tested up to: 5.8
 * Requires PHP: 5.2.4
 *
 * @package     wpsyncsheets-for-elementor
 * @author      Creative Werk Designs
 * @category    Plugin
 * @copyright   Copyright (c) 2021 Creative Werk Designs
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
define( 'WPSSE_PLUGIN_SECURITY', 1 );
define( 'WPSSE_PLUGIN_ID', '25171650' );
define( 'WPSSE_PLUGIN_ITEM_ID', '1386' );
define( 'WPSSE_STORE_URL', 'https://www.wpsyncsheets.com/' );
define( 'WPSSE_PLUGIN_NAME', 'WPSyncSheets For Elementor' );
// Plugin version.
define( 'WPSSE_VERSION', '4.2' );
// Plugin URL.
define( 'WPSSE_URL', plugin_dir_url( __FILE__ ) );
// Plugin directory.
define( 'WPSSE_DIR', plugin_dir_path( __FILE__ ) );
define( 'WPSSE_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'WPSSE_DIRECTORY', dirname( plugin_basename( __FILE__ ) ) );
define( 'WPSSE_PLUGIN_SLUG', WPSSE_DIRECTORY . '/' . basename( __FILE__ ) );
define( 'WPSSE_BASE_FILE', basename( dirname( __FILE__ ) ) . '/wpsyncsheets-for-elementor.php' );
define( 'WPSSE_DOCUMENTATION_URL', 'https://docs.wpsyncsheets.com/wpsse-introduction/' );
define( 'WPSSE_DOC_SHEET_SETTING_URL', 'https://docs.wpsyncsheets.com/wpsse-google-sheets-api-settings/' );
define( 'WPSSE_SUPPORT_URL', 'https://support.wpsyncsheets.com/index.php/signup?plugin=wpsse' );
define( 'WPSSE_VIDEO_TUTORIAL_URL', 'https://docs.wpsyncsheets.com/wpsse-video-tutorials/' );
define( 'WPSSE_PLUGIN_SETTING_URL', 'https://docs.wpsyncsheets.com/wpsse-plugin-settings/' );
define( 'WPSSE_DOC_MENU_URL', 'https://docs.wpsyncsheets.com' );
define( 'WPSSE_SUPPORT_MENU_URL', 'https://support.wpsyncsheets.com/index.php/signup' );

/**
 * Get list of active plugins.
 *
 * @param string $plugin plugin name.
 */
function wpsse_is_elementor_plugin_active( $plugin ) {
	return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true );
}
// Check WPSyncSheets For Elementor Dependency Class and Elementor Activation.
if ( wpsse_is_elementor_plugin_active( 'elementor-pro/elementor-pro.php' ) ) {
	// Add methods if Elementor Pro is active.
	add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wpsse_add_action_links' );
	/**
	 * Add setings link at plugin page.
	 *
	 * @param array $wpsse_links Add settings link.
	 */
	function wpsse_add_action_links( $wpsse_links ) {
		$wpsse_mylinks = array(
			'<a href="' . esc_url( admin_url( 'admin.php?page=wpsyncsheets-for-elementor' ) ) . '">' . esc_html__( 'Settings', 'wpsse' ) . '</a>',
		);
		return array_merge( $wpsse_mylinks, $wpsse_links );
	}
	// Define the class and the function.
	require_once dirname( __FILE__ ) . '/src/class-wpsyncsheets-elementor.php';
	wpsse();
} else {
	add_action( 'admin_notices', 'wppse_admin_notice' );
	if ( ! function_exists( 'wppse_admin_notice' ) ) {
		/**
		 * Add notice if Elementor pro plugin not install or active.
		 */
		function wppse_admin_notice() {
			?> 
			<div class="notice error">
				<div>
					<p><?php echo esc_html__( 'WPSyncSheets For Elementor plugin requires', 'wpsse' ); ?> <a href="<?php echo esc_url( 'https://elementor.com/pro/' ); ?>" target = "_blank"><?php echo esc_html__( 'Elementor Pro', 'wpsse' ); ?></a> <?php echo esc_html__( 'plugin to be active!', 'wpsse' ); ?></p>
				</div>
			</div>
			<?php
		}
	}
}
