<?php
	/**
	 * Main WPSyncSheets_Elementor namespace.
	 *
	 * @since 1.0.0
	 * @package wpsyncsheets-for-elementor
	 */

namespace WPSyncSheets_Elementor {
	/**
	 * Main WPSyncSheets_Elementor class.
	 *
	 * @since 1.0.0
	 * @package wpsyncsheets-for-elementor
	 */
	final class WPSyncSheets_Elementor {
		/**
		 * Instance of class variable.
		 *
		 * @since 1.0.0
		 *
		 * @var \WPSyncSheets_Elementor\WPSyncSheets_Elementor
		 */
		private static $instance;

		/**
		 * Plugin version for enqueueing, etc.
		 * The value is got from WPSSE_VERSION constant.
		 *
		 * @since 1.0.0
		 *
		 * @var string
		 */
		public $version = '';

		/**
		 * Main WPSyncSheets_Elementor Instance.
		 *
		 * Only one instance of WPSyncSheets_Elementor exists in memory at any one time.
		 * Also prevent the need to define globals all over the place.
		 *
		 * @since 1.0.0
		 *
		 * @return WPSyncSheets_Elementor
		 */
		public static function instance() {

			if ( null === self::$instance || ! self::$instance instanceof self ) {
				self::$instance = new self();
				self::$instance->constants();
				self::$instance->includes();
				add_action( 'init', array( self::$instance, 'load_textdomain' ), 10 );
			}

			return self::$instance;
		}

		/**
		 * Load the plugin language files.
		 *
		 * @since 1.0.0
		 */
		public function load_files() {
			self::$instance = new self();
			self::$instance->wpsse_include();
		}

		/**
		 * Setup plugin constants.
		 * All the path/URL related constants are defined in main plugin file.
		 *
		 * @since 1.0.0
		 */
		private function constants() {
			$this->version = WPSSE_VERSION;
		}

		/**
		 * Load the plugin language files.
		 *
		 * @since 1.0.0
		 */
		public function load_textdomain() {

			// If the user is logged in, unset the current text-domains before loading our text domain.
			// This feels hacky, but this way a user's set language in their profile will be used,
			// rather than the site-specific language.
			if ( is_user_logged_in() ) {
				unload_textdomain( 'wpsse' );
			}
			load_plugin_textdomain( 'wpsse', false, WPSSE_DIRECTORY . '/assets/languages/' );
		}

		/**
		 * Include files.
		 *
		 * @since 1.0.0
		 */
		private function includes() {

			// Global Includes.

			require_once WPSSE_PATH . '/includes/class-wpsse-google-api.php';
			require_once WPSSE_PATH . '/includes/class-wpsse-google-api-functions.php';
			require_once WPSSE_PATH . '/includes/class-wpsse-update.php';
			require_once WPSSE_PATH . '/includes/class-wpsse-license.php';
			require_once WPSSE_PATH . '/includes/class-wpsse-plugin-setting.php';
		}
	}
}

namespace {

	/**
	 * The function which returns the one WPSSE instance.
	 *
	 * @since 1.0.0
	 *
	 * @return WPSSE\wpsse
	 */
	function wpsse() {
		return WPSyncSheets_Elementor\WPSyncSheets_Elementor::instance();
	}
	class_alias( 'WPSyncSheets_Elementor\WPSyncSheets_Elementor', 'WPSyncSheets_Elementor' );
}
