<?php
/**
 * Handle plugin License.
 *
 * @package wpsyncsheets-for-elementor
 */

// Direct access security.
if ( ! defined( 'WPSSE_PLUGIN_SECURITY' ) ) {
	wp_die();
}
use WPSyncSheets_Elementor\WPSSE_Google_API_Functions;
/**
 * Class WPSSE_License.
 *
 * @since 1.0.0
 */
final class WPSSE_License {
	/**
	 * Check token valid or not..
	 *
	 * @var object $instance Instance.
	 * @since 1.0.0
	 */
	protected static $instance = null;
	/**
	 * Instance of WPSSE_Google_API_Functions class.
	 *
	 * @var $instance_api Instance variable of WPSSE_Google_API_Functions class.
	 */
	private static $instance_api = null;
	/**
	 * Create Class Instance.
	 *
	 * @since 1.0.0
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Get an instance of WPSSE_Google_API_Functions class.
	 *
	 * @return WPSSE_Google_API_Functions class instance
	 */
	public static function wpsse_google_api() {
		if ( null === self::$instance_api ) {
			self::$instance_api = new WPSSE_Google_API_Functions();
		}
		return self::$instance_api;
	}
	/**
	 * Primary class constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->wpsse_google_api();
		add_action( 'init', array( $this, 'wpsse_plugin_updater' ) );
	}
	/**
	 * Initialization
	 */
	public function init() {
	}
	/**
	 * Initialize the updater. Hooked into `init` to work with the
	 * wp_version_check cron job, which allows auto-updates.
	 */
	public function wpsse_plugin_updater() {

		// To support auto-updates, this needs to run during the wp_version_check cron job for privileged users.
		$doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
		if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
			return;
		}

		// retrieve our license key from the DB.
		$license_key = trim( self::$instance_api->wpsse_option( 'wpsse_license_key' ) );
		// setup the updater.
		$edd_updater = new WPSSE_Update(
			WPSSE_STORE_URL,
			WPSSE_BASE_FILE,
			array(
				'version' => WPSSE_VERSION,
				'license' => $license_key,
				'item_id' => WPSSE_PLUGIN_ITEM_ID,
				'author'  => 'Creative Werk Designs',
				'beta'    => false,
			)
		);
	}
}
