<?php
/**
 * Custom elementor form action after submit to add a records to
 * Google Spreadsheet
 *
 * @since 1.0.0
 * @package wpsyncsheets-for-elementor
 */

use ElementorPro\Plugin;
use Elementor\Controls_Manager;
use ElementorPro\Modules\Forms\Classes\Action_Base;
use ElementorPro\Modules\Forms\Controls\Fields_Map;
use WPSyncSheets_Elementor\WPSSE_Google_API_Functions;
/**
 * Class WPSSE_Form_Sheets_Action
 */
class WPSSE_Form_Sheets_Action extends \ElementorPro\Modules\Forms\Classes\Action_Base {
	/**
	 * Get Name
	 *
	 * Return the action name
	 *
	 * @access public
	 * @return string
	 */
	public function get_name() {
		return esc_html( 'elementorsheets' );
	}
	/**
	 * Get Label
	 *
	 * Returns the action label
	 *
	 * @access public
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'WPSyncSheets', 'wpsse' );
	}
	/**
	 * Run
	 *
	 * Runs the action after submit
	 *
	 * @access public
	 * @param \ElementorPro\Modules\Forms\Classes\Form_Record  $record Record.
	 * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler Ajax handler.
	 */
	public function run( $record, $ajax_handler ) {
		$wpsse_settings = $record->get( 'form_settings' );
		// Get sumitetd Form data.
		$wpsse_raw_fields = $record->get( 'fields' );
		$instance_api     = new WPSyncSheets_Elementor\WPSSE_Google_API_Functions();
		if ( ! $instance_api->checkcredenatials() ) {
			return;
		}
		if ( isset( $wpsse_settings['submit_actions'] ) && in_array( $this->get_name(), $wpsse_settings['submit_actions'], true ) ) {
			$wpsse_spreadsheetid = $wpsse_settings['spreadsheetid'];
			$wpsse_sheetname     = $wpsse_settings['sheet_name'];
			$wpsse_sheetarray    = WPSSE_Plugin_Setting::wpsse_list_googlespreedsheet();
			if ( ( ! empty( $wpsse_spreadsheetid ) && ! array_key_exists( $wpsse_spreadsheetid, $wpsse_sheetarray ) ) || 'new' === (string) $wpsse_spreadsheetid ) {
				return;
			} elseif ( ! empty( $wpsse_spreadsheetid ) ) {
				$response = $instance_api->get_sheet_listing( $wpsse_spreadsheetid );
				foreach ( $response->getSheets() as $s ) {
					$wpsse_sheets[] = $s['properties']['title'];
				}
				if ( ! empty( $wpsse_sheetname ) && ! in_array( $wpsse_sheetname, $wpsse_sheets, true ) ) {
					return;
				}
			}
			if ( empty( $wpsse_spreadsheetid ) || empty( $wpsse_sheetname ) ) {
				return;
			}
			$wpsse_lead_created_date = '';
			if ( isset( $wpsse_settings['lead_created_date'] ) ) {
				$wpsse_lead_created_date = $wpsse_settings['lead_created_date'];
			}

			$wpsse_page_url = '';
			if ( isset( $wpsse_settings['lead_created_page_url'] ) ) {
				$wpsse_page_url = $wpsse_settings['lead_created_page_url'];
			}
			// Normalize the Form Data.

			$wpsse_fields = array();
			foreach ( $wpsse_raw_fields as $id => $field ) {
				$wpsse_fields[ $id ] = $field['value'];
			}

			try {
				if ( isset( $wpsse_settings['elementorsheets_fields_map'] ) && ! empty( $wpsse_settings['elementorsheets_fields_map'] ) ) {
					$wpsse_headers = array_column( $wpsse_settings['elementorsheets_fields_map'], 'local_id' );
				} else {
					$wpsse_headers = $wpsse_settings['sheet_headers'];
				}

				$wpsse_value_data = array();
				foreach ( $wpsse_headers as $wpsse_fieldvalue ) {
					if ( array_key_exists( $wpsse_fieldvalue, $wpsse_fields ) ) {
						if ( is_array( $wpsse_fields[ $wpsse_fieldvalue ] ) ) {
							$wpsse_value_data[] = implode( ',', $wpsse_fields[ $wpsse_fieldvalue ] );
						} else {
							$wpsse_value_data[] = $wpsse_fields[ $wpsse_fieldvalue ];
						}
					} else {
						$wpsse_value_data[] = '';
					}
				}

				$wpsse_sheet    = $wpsse_sheetname;
				$wpsse_allentry = $instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_sheet );
				$wpsse_data     = $wpsse_allentry->getValues();

				$wpsse_data = array_map(
					function( $wpsse_element ) {
						if ( isset( $wpsse_element['0'] ) ) {
							return $wpsse_element['0'];
						} else {
							return '';
						}
					},
					$wpsse_data
				);

				$wpsse_range    = trim( $wpsse_sheetname ) . '!A1:ZZ1';
				$wpsse_allentry = $instance_api->get_row_list( $wpsse_spreadsheetid, $wpsse_range );
				$wpssepre_data  = $wpsse_allentry->getValues();

				$wpsse_prevoius_headers = isset( $wpssepre_data[0] ) ? $wpssepre_data[0] : array();
				if ( in_array( (string) 'Submission Date', $wpsse_prevoius_headers, true ) && in_array( (string) 'Page Referer Url', $wpsse_prevoius_headers, true ) ) {
					$wpsse_date_index = array_search( 'Submission Date', $wpsse_prevoius_headers, true );
					$wpsse_url_index  = array_search( 'Page Referer Url', $wpsse_prevoius_headers, true );

					if ( $wpsse_date_index < $wpsse_url_index ) {
						if ( 'yes' === (string) $wpsse_lead_created_date ) {
							// phpcs:ignore
							$wpsse_value_data[] = WPSSE_Plugin_Setting::wpsse_get_date( current_time( 'timestamp' ) );
						} else {
							$wpsse_value_data[] = '';
						}
						if ( 'yes' === (string) $wpsse_page_url ) {
							if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
								$wpsse_value_data[] = urldecode( sanitize_text_field( wp_unslash( $_SERVER['HTTP_REFERER'] ) ) );
							}
						} else {
							$wpsse_value_data[] = '';
						}
					} else {
						if ( 'yes' === (string) $wpsse_page_url ) {
							if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
								$wpsse_value_data[] = urldecode( sanitize_text_field( wp_unslash( $_SERVER['HTTP_REFERER'] ) ) );
							}
						} else {
							$wpsse_value_data[] = '';
						}
						if ( 'yes' === (string) $wpsse_lead_created_date ) {
							// phpcs:ignore
							$wpsse_value_data[] =WPSSE_Plugin_Setting::wpsse_get_date( current_time( 'timestamp' ) );
						} else {
							$wpsse_value_data[] = '';
						}
					}
				} else {
					if ( 'yes' === (string) $wpsse_page_url ) {
						if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
							$wpsse_value_data[] = urldecode( sanitize_text_field( wp_unslash( $_SERVER['HTTP_REFERER'] ) ) );
						}
					}
					if ( 'yes' === (string) $wpsse_lead_created_date ) {
							// phpcs:ignore
						$wpsse_value_data[] = WPSSE_Plugin_Setting::wpsse_get_date( current_time( 'timestamp' ) );
					}
				}
				$wpsse_rangetoupdate = $wpsse_sheetname . '!A' . ( count( $wpsse_data ) + 1 );
				$wpsse_requestbody   = $instance_api->valuerangeobject( array( $wpsse_value_data ) );
				$wpsse_params        = WPSSE_Plugin_Setting::get_row_format();
				$param               = $instance_api->setparamater( $wpsse_spreadsheetid, $wpsse_rangetoupdate, $wpsse_requestbody, $wpsse_params );
				$instance_api->updateentry( $param );
			} catch ( Exception $e ) {
				$ajax_handler->add_admin_error_message( 'WPSyncSheets ' . $e->getMessage() );
			}
		}
	}

	/**
	 * Register Settings Section
	 *
	 * Registers the Action controls
	 *
	 * @access public
	 * @param \Elementor\Widget_Base $widget settings.
	 */
	public function register_settings_section( $widget ) {

		$instance_api = new \WPSyncSheets_Elementor\WPSSE_Google_API_Functions();

		$wpsse_google_settings = $instance_api->wpsse_option( 'wpsse_google_settings' );

		global $wpsse_headers, $wpsse_default_headers, $wpsse_exclude_headertype;
		global $wpsse_spreadsheetid , $wpsse_sheetname, $wpsse_sheet_headers, $wpsse_sheetheaders, $existincurrentpage, $wpsse_sheetheaders_new ,$wpsse_form_fields;

		$existincurrentpage     = 'no';
		$wpsse_sheetheaders     = array();
		$wpsse_sheetheaders_new = array();
		$wpsse_form_fields      = array();

		$wpsse_exclude_headertype = array( 'honeypot', 'recaptcha', 'recaptcha_v3', 'html' );
		$wpsse_document           = Plugin::elementor()->documents->get( get_the_ID() );

		if ( $wpsse_document ) {

			$wpsse_data        = $wpsse_document->get_elements_data();
			$wpsse_data_global = $wpsse_data;
			global $wpsse_type;
			$wpsse_type = '';
			array_walk_recursive(
				$wpsse_data,
				function( &$value, $key ) {
					global $wpsse_type;
					global $wpsse_exclude_headertype;
					if ( 'field_type' === (string) $key ) {
						$wpsse_type = $value;
					}

					if ( 'field_label' === (string) $key ) {
						global $wpsse_form_fields;
						if ( empty( $wpsse_form_fields ) || ! in_array( $value, $wpsse_form_fields, true ) ) {
							if ( ! in_array( $wpsse_type, $wpsse_exclude_headertype, true ) ) {
								$wpsse_form_fields[] = $value;
								$wpsse_type          = '';
							}
						}
					}
					if ( 'elementorsheets' === (string) $value ) {
						global $existincurrentpage;
						$existincurrentpage = 'yes';
					}
				}
			);
			$wpsse_allheaders = array();
			if ( 'yes' === (string) $existincurrentpage ) {
				$wpsse_allheaders = WPSSE_Plugin_Setting::wpsse_get_headers( $wpsse_data );
				foreach ( $wpsse_allheaders as $key => $value ) {
					if ( empty( $wpsse_sheetheaders_new ) || ! in_array( $value, $wpsse_sheetheaders_new, true ) ) {
						$wpsse_sheetheaders_new[] = $value;
					}
				}
			}
			array_walk_recursive(
				$wpsse_data,
				function( &$value, $key ) {
					global $existincurrentpage, $wpsse_sheetheaders,$wpsse_sheetheaders_new,$wpsse_spreadsheetid , $wpsse_sheetname;

					if ( 'spreadsheetid' === (string) $key ) {
						$wpsse_spreadsheetid = $value;
					}
					if ( 'sheet_name' === (string) $key ) {
						$wpsse_sheetname = $value;
					}
				}
			);
			if ( ! empty( $wpsse_sheetheaders_new ) ) {
				$wpsse_sheetheaders = $wpsse_sheetheaders_new;
			} else {
				$wpsse_sheetheaders = $wpsse_form_fields;
			}
			array_walk_recursive(
				$wpsse_data,
				function( &$value, $key ) {

					global $existincurrentpage, $wpsse_sheetheaders,$wpsse_sheetheaders_new;

					if ( 'no' === (string) $existincurrentpage ) {
						if ( 'templateID' === (string) $key ) {
							$form = get_post_meta( $value, '_elementor_template_widget_type' );
							if ( in_array( 'form', $form, true ) ) {
								$formdata       = get_post_meta( $value, '_elementor_data' );
								$globalformdata = json_decode( $formdata[0], true );

								global $wpsse_sheetheaders;
								$wpsse_templateheaders = WPSSE_Plugin_Setting::wpsse_get_headers( $globalformdata );
								foreach ( $wpsse_templateheaders as $formkey => $formvalue ) {
									if ( ! in_array( $formvalue, $wpsse_sheetheaders, true ) ) {
										$wpsse_sheetheaders[] = $formvalue;
									}
								}
							}
						}
					}
				}
			);
		}

		if ( ! is_array( $wpsse_sheetheaders ) ) {
			$wpsse_sheetheaders = array();
		}

		if ( empty( $wpsse_google_settings[2] ) ) {

			$wpsse_html = sprintf(
				'<div class="elementor-control-raw-html elementor-panel-alert elementor-panel-alert-danger">%1$s<a href="admin.php?page=wpsyncsheets-for-elementor"> <strong>%2$s</strong></a>.</div>',
				esc_html__( 'Please genearate authentication code from Google Sheet Setting', 'wpsse' ),
				esc_html__( 'Click Here', 'wpsse' )
			);

			$widget->start_controls_section(
				'section_notice_wpsse',
				array(
					'label'     => esc_attr__( 'WPSyncSheets', 'wpsse' ),
					'condition' => array(
						'submit_actions' => $this->get_name(),
					),
				)
			);

			$widget->add_control(
				'setup_clientidsecret',
				array(
					'type' => \Elementor\Controls_Manager::RAW_HTML,
					'raw'  => $wpsse_html,
				)
			);

			$widget->end_controls_section();
		} elseif ( ! empty( $wpsse_google_settings[2] ) && ! $instance_api->checkcredenatials() ) {

			$wpsse_error = $instance_api->getClient( 1 );
			if ( 'Invalid token format' === (string) $wpsse_error || 'invalid_grant' === (string) $wpsse_error ) {
				$wpsse_html = sprintf(
					'<div class="elementor-control-raw-html elementor-panel-alert elementor-panel-alert-danger">%1$s<a href="admin.php?page=wpsyncsheets-for-elementor"> <strong>%2$s</strong></a>.</div>',
					esc_html__( 'Error: Invalid Token - Revoke Token with Google Sheet Setting and try again.', 'wpsse' ),
					esc_html__( 'Click Here', 'wpsse' )
				);
			} else {
				$wpsse_html = sprintf(
					'<div class="elementor-control-raw-html elementor-panel-alert elementor-panel-alert-danger">%1$s</div>',
					'Error: ' . $wpsse_error
				);
			}

			$widget->start_controls_section(
				'section_notice_wpsse',
				array(
					'label'     => esc_attr__( 'WPSyncSheets', 'wpsse' ),
					'condition' => array(
						'submit_actions' => $this->get_name(),
					),
				)
			);

			$widget->add_control(
				'setup_clientidsecret',
				array(
					'type' => \Elementor\Controls_Manager::RAW_HTML,
					'raw'  => $wpsse_html,
				)
			);

			$widget->end_controls_section();
		} else {

			if ( ! empty( $wpsse_headers ) && is_array( $wpsse_headers ) ) {
				$wpsse_headers = implode( ',', $wpsse_headers );
			} else {
				$wpsse_headers = '';
			}
			$sorting_headers = '<div class="wpsse-sheetsheaders"><label class="wpsse-sheetsheaders-title">Sheet Headers</label><ul id="sortable" class="ui-sortable">';
			foreach ( $wpsse_sheetheaders as $header ) {
				$newheader        = str_replace( ' ', '_', strtolower( $header ) );
				$sorting_headers .= '<li class="ui-state-default ui-sortable-handle"><label for=' . $newheader . '><span class="ui-icon ui-icon-caret-2-n-s"></span>
					<div id="wpsse-panel-field-wpsse-sheetheaders-' . $newheader . '-wrap" class="wpsse-panel-field custom-swap custom-sort-headers wpsse-panel-field-checkbox">
						<label for="wpsse-panel-field-wpsse-sheetheaders-' . $newheader . '" class="inline hdrtext">' . $header . '</label>
							<label for="wpsse-panel-field-wpsse-sheetheaders-' . $newheader . '"><label for="wpsse-panel-field-wpsse-sheetheaders-' . $newheader . '">
								<span class="ui-icon ui-icon-close"></span>
							</label>
							<span class="checkbox-switch"></span>
						</label>
					</div>
				</li>';
			}
			$sorting_headers .= '</ul></div><div id="form_all_headers" class="form-all-headers">' . $wpsse_headers . '</div>';

			$wpsse_spreadsheets = WPSSE_Plugin_Setting::wpsse_list_googlespreedsheet();

			$wpsse_sheets = array();

			if ( ! empty( $wpsse_spreadsheetid ) && 'new' !== (string) $wpsse_spreadsheetid && array_key_exists( $wpsse_spreadsheetid, $wpsse_spreadsheets ) ) {
				$response = $instance_api->get_sheet_listing( $wpsse_spreadsheetid );
				foreach ( $response->getSheets() as $s ) {
					$wpsse_sheets[] = $s['properties']['title'];
				}
			}

			$widget->start_controls_section(
				'section_wpsse',
				array(
					'label'     => esc_attr__( 'WPSyncSheets', 'wpsse' ),
					'condition' => array(
						'submit_actions' => $this->get_name(),
					),
				)
			);

			$widget->add_control(
				'spreadsheetid',
				array(
					'label'       => esc_attr__( 'Select Spreadsheet', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::SELECT,
					'options'     => $wpsse_spreadsheets,
					'label_block' => true,
					'separator'   => 'before',
				)
			);

			$widget->add_control(
				'new_spreadsheet_name',
				array(
					'label'       => esc_attr__( 'Spreadsheet Name', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'condition'   => array(
						'spreadsheetid' => 'new',
					),
				)
			);

			$widget->add_control(
				'sheet_name',
				array(
					'label'       => esc_attr__( 'Sheet Name', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
				)
			);
			$widget->add_control(
				'sheet_list',
				array(
					'label'       => esc_attr__( 'Select Sheet Name', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::SELECT,
					'label_block' => true,
					'options'     => $wpsse_sheets,
				)
			);
			$widget->add_control(
				'view_spreadsheet',
				array(
					'label'       => '',
					'type'        => \Elementor\Controls_Manager::BUTTON,
					'button_type' => 'viewspreadsheet',
					'text'        => __( 'View Spreadsheet', 'wpsse' ),
					'event'       => 'namespace:editor:viewsheet',
				)
			);

			$widget->add_control(
				'headers_listing_ul',
				array(
					'type'      => \Elementor\Controls_Manager::RAW_HTML,
					'raw'       => $sorting_headers,
					'separator' => 'before',
				)
			);
			$widget->add_control(
				'header_name',
				array(
					'label'       => __( 'Header Name', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'label_block' => true,
					'separator'   => 'before',
				)
			);

			$widget->add_control(
				'add_header_title',
				array(
					'label'       => '',
					'type'        => \Elementor\Controls_Manager::BUTTON,
					'button_type' => 'addcustomheaders',
					'text'        => __( 'Add', 'wpsse' ),
					'event'       => 'namespace:editor:getheaders',
				)
			);

			$widget->add_control(
				'elementorsheets_fields_map',
				array(
					'label'     => __( 'Sheet Headers Mapping Form Fields', 'wpsse' ),
					'type'      => Fields_Map::CONTROL_TYPE,
					'separator' => 'before',
					'fields'    => array(
						array(
							'name' => 'remote_id',
							'type' => Controls_Manager::HIDDEN,
						),
						array(
							'name' => 'local_id',
							'type' => Controls_Manager::SELECT,
						),
					),
				)
			);

			$widget->add_control(
				'lead_created_date',
				array(
					'label'        => esc_attr__( 'Submission Date', 'wpsse' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_off'    => 'No',
					'label_on'     => 'Yes',
					'return_value' => 'yes',
				)
			);

			$widget->add_control(
				'lead_created_page_url',
				array(
					'label'        => esc_attr__( 'Page Referer Url', 'wpsse' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_off'    => 'No',
					'label_on'     => 'Yes',
					'return_value' => 'yes',
				)
			);

			$widget->add_control(
				'freeze_header',
				array(
					'label'        => esc_attr__( 'Freeze Headers', 'wpsse' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_off'    => 'No',
					'label_on'     => 'Yes',
					'return_value' => 'yes',
				)
			);

			if ( version_compare( ELEMENTOR_PRO_VERSION, '3.2.0', '>=' ) ) {
				$widget->add_control(
					'wpsse_sync',
					array(
						'label'       => __( 'Sync Form Entries', 'wpsse' ),
						'type'        => \Elementor\Controls_Manager::BUTTON,
						'button_type' => 'clicktosync',
						'text'        => __( 'Click to Sync', 'wpsse' ),
					)
				);
			}
			$widget->add_control(
				'wpsse_clearsheet',
				array(
					'label'       => __( 'Clear Sheet', 'wpsse' ),
					'type'        => \Elementor\Controls_Manager::BUTTON,
					'button_type' => 'clearsheet',
					'text'        => __( 'Clear', 'wpsse' ),
				)
			);
			$widget->end_controls_section();
		}
	}
	/**
	 * On Export
	 *
	 * Clears form settings on export
	 *
	 * @access Public
	 * @param array $element_sheets clear settings.
	 */
	public function on_export( $element_sheets ) {
	}
}

