/**
 * Admin Enqueue Script
 *
 * @package     wpsyncsheets-for-elementor
 */

jQuery( window ).on(
	'load',
	function () {
		"use strict";
		var headerNamesGlobal = [];
		(function (e, ep, $) {
			var WPSSEoptinIntegration = {
				onElementChange: function onElementChange(setting) {
					var self = this;
					switch (setting) {
						case 'generate_mapping':
							self.updateFieldsMapping();
							break;
					}
				},
				onSectionActive: function onSectionActive(setting) {
					var self = this;
					this.updateFieldsMapping();
					var newList = '';
					jQuery( '.elementor-control-sheet_list' ).hide();

					var spreadsheet_id   = jQuery( "[data-setting = spreadsheetid]" ).val();
					var spreadsheet_list = [];
					if ( String( spreadsheet_id ) !== '' || parseInt( spreadsheet_id ) !== 0) {
						spreadsheet_list = jQuery( "[data-setting = spreadsheetid] option" ).map(
							function() {
								return (jQuery( this ).val());
							}
						).get();
						if (jQuery.inArray( spreadsheet_id, spreadsheet_list ) === -1) {
							jQuery( "[data-setting = spreadsheetid]" ).val( '' ).change();
							jQuery( '[data-setting = sheet_name]' ).val( '' ).trigger( 'input' );
						} else {
							var sheet_name = jQuery( "[data-setting = sheet_name]" ).val();
							var sheet_list = [];
							if ( String( sheet_name ) !== '') {
								sheet_list = jQuery( "[data-setting = sheet_list] option" ).map(
									function() {
										return (jQuery( this ).text());
									}
								).get();
								if (sheet_list.length > 0 && jQuery.inArray( sheet_name, sheet_list ) === -1) {
									jQuery( '[data-setting = sheet_name]' ).val( '' ).trigger( 'input' );
								}
							}
						}
					}
					if ( jQuery( "[data-setting = spreadsheetid]" ).val() == null || jQuery( "[data-setting = spreadsheetid]" ).val() == '' ) {
						jQuery( '.elementor-control-view_spreadsheet' ).hide();
						jQuery( '.elementor-control-wpsse_sync' ).hide();
						jQuery( '.elementor-control-wpsse_clearsheet' ).hide();
					}
					if ( jQuery( "[data-setting = sheet_name]" ).val() == '' ) {
						jQuery( '.elementor-control-wpsse_sync' ).hide();
						jQuery( '.elementor-control-wpsse_clearsheet' ).hide();
					}

					var headerNamesGloballength = headerNamesGlobal.length;

					if ( headerNamesGloballength > 0) {
						jQuery( '#sortable' ).html( '' );
					}
					for (var i = 0; i < headerNamesGloballength; ++i) {
						var labelId = headerNamesGlobal[i].replace( / /g,"-" ).toLowerCase();
						var newList = '<li class="ui-state-default ui-sortable-handle"><label for="' + labelId + '"><span class="ui-icon ui-icon-caret-2-n-s"></span><div id="elementorsheets-panel-field-wpsse-sheetheaders-' + labelId + '-wrap" class="wpsse-panel-field custom-swap custom-sort-headers wpsse-panel-field-checkbox"><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '" class="inline hdrtext">' + headerNamesGlobal[i] + '</label><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '"><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '"><span class="ui-icon ui-icon-close" data-header-name=' + headerNamesGlobal[i] + '></span></label><span class="checkbox-switch"></span></label></div></li>';
						jQuery( '#sortable' ).append( newList );
					}
					$( "#sortable" ).sortable(
						{
							update: function(event, ui) {
								headerNamesGlobal = [];
								$( 'ul#sortable li .hdrtext' ).each(
									function(i){
										if ( $( this ).text() != '' ) {
											headerNamesGlobal.push( $.trim( $( this ).text() ) );
										}
									}
								);
								self.onElementChange( 'generate_mapping' );
							},
						}
					);
					$( "#sortable" ).on(
						'sortupdate',
						function() {
							self.onElementChange( 'generate_mapping' );
						}
					);

					$( 'body' ).on(
						'click',
						'.wpsse-sheetsheaders .ui-icon-close' ,
						function(e) {

							var removeItem    = $( this ).attr( 'data-header-name' );
							headerNamesGlobal = $.grep(
								headerNamesGlobal,
								function(value) {
									return value != removeItem;
								}
							);

							$( this ).closest( 'li' ).fadeOut( 1000, function() { $( this ).closest( 'li' ).remove(); } );
							setTimeout(
								function(){
									$( '#sortable' ).trigger( 'sortupdate' );
								},
								1100
							);
						}
					);

					var availableFormField = $( "#form_all_headers" ).html().split( "," );
					availableFormField     = $.grep(
						availableFormField,
						function(value) {
							if ( parseInt( jQuery.inArray( value, headerNamesGlobal ) ) === -1 ) {
								return value;
							}
						}
					);
					$( 'input[data-setting=header_name]' ).autocomplete(
						{
							source: availableFormField
						}
					);
				},
				updateFieldsMapping: function updateFieldsMapping(model) {
					var self = this;
					self.getEditorControlView( 'elementorsheets_fields_map' ).$el.hide();
					var headerNames = [];
					$( 'ul#sortable li .hdrtext' ).each(
						function(i){
							if ( $( this ).text() != '' ) {
								headerNames.push( $.trim( $( this ).text() ) );
								if ( parseInt( jQuery.inArray( $.trim( $( this ).text() ), headerNamesGlobal ) ) === -1 ) {
										headerNamesGlobal.push( $.trim( $( this ).text() ) );
								}
							}
						}
					);
					var availableFormField = $( "#form_all_headers" ).html().split( "," );
					availableFormField     = $.grep(
						availableFormField,
						function(value) {
							if ( parseInt( jQuery.inArray( value, headerNamesGlobal ) ) === -1 ) {
								return value;
							}
						}
					);
					$( 'input[data-setting=header_name]' ).autocomplete(
						{
							source: availableFormField
						}
					);

					$( ".elementor-button-clicktosync" ).on(
						"click",
						function(e){
							e.preventDefault();
							e.stopPropagation();
							var form_id = $( '#elementor-preview-iframe' ).contents().find( 'input[name=form_id]' ).val();
							var post_id = $( '#elementor-preview-iframe' ).contents().find( 'input[name=post_id]' ).val();
							var data    = {
								action: 'wpsse_sync_data',
								form_id: form_id,
								post_id	: post_id,
								sync_nonce_token : customadmin_ajax_object.sync_nonce_token
							};
							$.ajax(
								{
									url : customadmin_ajax_object.ajaxurl,
									type : 'post',
									data :data,
									beforeSend:function(){
										$( '.elementor-button.elementor-button-clicktosync' ).html( 'Synchronizing...' );
									},
									success : function( response ) {
										if (String( response ) === 'success') {
											alert( 'All Entries Synchronized Successfully.' );
										} else if ( String( response ) === 'notfound' ) {
											alert( 'No Submission found' );
										} else {
											alert( response );
										}
										$( '.elementor-button.elementor-button-clicktosync' ).html( 'Click to Sync' );
									},
									error: function (s) {
										alert( 'Error' );
									}
								}
							);
						}
					);
					$( ".elementor-button-clearsheet" ).on(
						"click",
						function(e){
							e.preventDefault();
							e.stopPropagation();
							var post_id = getParameterByName( 'post' );
							var data    = {
								action: 'wpsse_clear_data',
								post_id	: post_id,
								sync_nonce_token : customadmin_ajax_object.sync_nonce_token
							};
							$.ajax(
								{
									url : customadmin_ajax_object.ajaxurl,
									type : 'post',
									data :data,
									beforeSend:function(){
										if (confirm( "Are you sure you want to clear sheet?" )) {
											$( '.elementor-button.elementor-button-clearsheet' ).html( 'Clearing...' );
										} else {
											return false;
										}
									},
									success : function( response ) {
										if ( response.toString() === 'success') {
											$( '.elementor-button.elementor-button-clearsheet' ).html( 'Clear' );
											alert( 'Spreadsheet Cleared successfully' );
										} else {
											alert( response );
										}
										$( '.elementor-button.elementor-button-clearsheet' ).html( 'Clear' );
									},
									error: function (s) {
										alert( 'Error' );
									}
								}
							);
						}
					);
					var i;
					var remoteFields            = [];
					var headerNamesGloballength = headerNamesGlobal.length;
					for (var i = 0; i < headerNamesGloballength; ++i) {
						var filedarray = {
							remote_label: headerNamesGlobal[i],
							remote_type: 'text',
							remote_id: headerNamesGlobal[i].toLowerCase(),
							remote_required: false
						};
						remoteFields.push( filedarray );
					}
					self.getEditorControlView( 'elementorsheets_fields_map' ).updateMap( remoteFields );
					self.getEditorControlView( 'elementorsheets_fields_map' ).$el.show();
				},
			};
			ep.modules.forms.wpsse = Object.assign( ep.modules.forms.mailchimp, WPSSEoptinIntegration );
			ep.modules.forms.wpsse.addSectionListener( 'section_wpsse', WPSSEoptinIntegration.onSectionActive );
		})( elementor, elementorPro, jQuery );
		elementor.channels.editor.on(
			'namespace:editor:getheaders',
			function( view ) {

				var cstVal = jQuery( 'input[data-setting=header_name]' ).val();
				if ( jQuery.inArray( cstVal, headerNamesGlobal ) != -1 ) {
					alert( 'Please enter unique sheet header name' );
					return false;
				}
				var labelId = cstVal.replace( / /g,"-" ).toLowerCase();
				var newList = '<li class="ui-state-default ui-sortable-handle" style="display:none"><label for="' + labelId + '"><span class="ui-icon ui-icon-caret-2-n-s"></span><div id="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '-wrap" class="wpsse-panel-field custom-swap custom-sort-headers wpsse-panel-field-checkbox"><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '" class="inline hdrtext">' + cstVal + '</label><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '"><label for="wpsse-panel-field-wpsse-sheetheaders-' + labelId + '"><span class="ui-icon ui-icon-close" data-header-name=' + cstVal + '></span></label><span class="checkbox-switch"></span></label></div></li>';
				jQuery( '#sortable' ).append( newList );
				jQuery( "#sortable li" ).each(
					function() {
						if (String( jQuery( this ).css( 'display' ) ) === 'none') {
							jQuery( this ).fadeIn( 2000 );
						}
					}
				);
				jQuery( 'input[data-setting=header_name]' ).val( '' );
				jQuery( '#sortable' ).trigger( 'sortupdate' );
			}
		);

		elementor.channels.editor.on(
			'namespace:editor:viewsheet',
			function( view ) {

				var value = jQuery( "[data-setting = spreadsheetid]" ).val();

				if ( String( value ) === '' ) {
					alert( 'Please Select Spreadsheet' );
					return false;
				}
				var URL = 'https://docs.google.com/spreadsheets/d/' + value;
				window.open( URL,"_blank" );
			}
		);

		function getParameterByName(name, url) {
			if ( ! url) {
				url = window.location.href;
			}
			name        = name.replace( /[\[\]]/g, '\\$&' );
			var regex   = new RegExp( '[?&]' + name + '(=([^&#]*)|&|#|$)' ),
				results = regex.exec( url );
			if ( ! results) {
				return null;
			}
			if ( ! results[2]) {
				return '';
			}
			return decodeURIComponent( results[2].replace( /\+/g, ' ' ) );
		}
	}
);
