<?php

class Hostinger_Onboarding_Connect_Domain_Step extends Hostinger_Onboarding_Step {

	private const HOSTINGER_ADD_DOMAIN_URL = 'https://hpanel.hostinger.com/add-domain/';
	private const HOSTINGER_WEBSITES_URL = 'https://hpanel.hostinger.com/websites';
	private const HOSTINGER_DOMAIN_SEARCHER = 'https://hpanel.hostinger.com/domains/domain-checker';
	public function get_title(): string {
		return __( 'Connect your domain', 'hostinger' );
	}

	public function get_body(): array {
		return [
			[
				'title'       => __( 'Get a domain', 'hostinger' ),
				'description' => $this->get_domain_html()
			],
			[
				'title'       => __( 'Connect your domain to Hostinger', 'hostinger' ),
				'description' => $this->connect_domain_html()
			],
			[
				'title'       => __( 'Wait for domain propagation', 'hostinger' ),
				'description' => __( 'Domain propagation can take up to 24 hours. Your domain will propagate automatically, and you don\'t need to take any action during this time.', 'hostinger' )
			],
		];
	}

	private function get_domain_html(): string {
		ob_start(); ?>
		<div class="hts-get-domain hts-domain-step">
			<p>
				<?= __( 'Your website is already published and can be accessed using Hostinger free temporary subdomain right now. Here is the current URL of your website:', 'hostinger' ) ?>
			</p>
			<div class="hts-website-url">
				<?= __( 'Website URL', 'hostinger' ) ?> <span><?= get_site_url() ?></span>
			</div>
			<p class="hts-domain-searcher">
				<?= __('You need to purchase a domain for your website before the preview domain becomes inaccessible. Find a desired website name using a', 'hostinger' ) ?>
				<a href="<?= self::HOSTINGER_DOMAIN_SEARCHER ?>"><?= __('domain name searcher.', 'hostinger')?></a>
			</p>
		</div>
		<?php return ob_get_clean();
	}

	private function connect_domain_html(): string {
		ob_start(); ?>
		<div class="hts-connect-domain hts-domain-step">
			<p>
				<?= __( 'You can connect domain to Hostinger by changing the nameservers. Different domain providers are have unique procedures for changing nameservers. Here are Hostinger\'s nameservers:', 'hostinger' ) ?>
			</p>
			<div class="hts-nameservers">
				<div>
					<p><?= __( 'Nameserver 1', 'hostinger' ) ?></p> <b>ns1.dns-parking.com <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M10.6668 0.666687H2.66683C1.9335 0.666687 1.3335 1.26669 1.3335 2.00002V11.3334H2.66683V2.00002H10.6668V0.666687ZM12.6668 3.33335H5.3335C4.60016 3.33335 4.00016 3.93335 4.00016 4.66669V14C4.00016 14.7334 4.60016 15.3334 5.3335 15.3334H12.6668C13.4002 15.3334 14.0002 14.7334 14.0002 14V4.66669C14.0002 3.93335 13.4002 3.33335 12.6668 3.33335ZM12.6668 14H5.3335V4.66669H12.6668V14Z" fill="#673DE6"/>
						</svg>
					</b>
				</div>
				<div>
					<p><?= __( 'Nameserver 2', 'hostinger' ) ?></p> <b>ns2.dns-parking.com <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M10.6668 0.666687H2.66683C1.9335 0.666687 1.3335 1.26669 1.3335 2.00002V11.3334H2.66683V2.00002H10.6668V0.666687ZM12.6668 3.33335H5.3335C4.60016 3.33335 4.00016 3.93335 4.00016 4.66669V14C4.00016 14.7334 4.60016 15.3334 5.3335 15.3334H12.6668C13.4002 15.3334 14.0002 14.7334 14.0002 14V4.66669C14.0002 3.93335 13.4002 3.33335 12.6668 3.33335ZM12.6668 14H5.3335V4.66669H12.6668V14Z" fill="#673DE6"/>
						</svg>
					</b>
				</div>
			</div>
			<p>
				<?= __('Learn how to connect your domain to Hostinger by watching this tutorial on YouTube for a step-by-step guide:', 'hostinger' ) ?>
			</p>
			<div class="hts-yt-video">
				<div class="hts-wrap">
				<div class="hts-img">
					<img src="<?php echo esc_url( HOSTINGER_PLUGIN_URL . 'assets/images/point-domain-cover.png' ); ?>" alt="video-cover">
				</div>
				<div class="hts-video-description">
					<b><?= __( 'How to Point Domain Name to Web Hosting', 'hostinger' ) ?></b>
					<p>03:46</p>
				</div>
				</div>
				<div class="hts-video-button">
					<a href="https://www.youtube.com/watch?v=UAsYeTL8cZc" target="_blank" rel="noopener noreferrer">
						<svg width="151" height="32" viewBox="0 0 151 32" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M22.3335 17.7789C22.3335 18.3064 22.917 18.6249 23.3607 18.3397L26.1278 16.5608C26.536 16.2984 26.536 15.7017 26.1278 15.4393L23.3607 13.6604C22.917 13.3751 22.3335 13.6937 22.3335 14.2212V17.7789ZM24.0002 22.6667C23.0779 22.6667 22.2113 22.4917 21.4002 22.1417C20.5891 21.7917 19.8835 21.3167 19.2835 20.7167C18.6835 20.1167 18.2085 19.4112 17.8585 18.6C17.5085 17.7889 17.3335 16.9223 17.3335 16C17.3335 15.0778 17.5085 14.2112 17.8585 13.4C18.2085 12.5889 18.6835 11.8834 19.2835 11.2834C19.8835 10.6834 20.5891 10.2084 21.4002 9.85837C22.2113 9.50837 23.0779 9.33337 24.0002 9.33337C24.9224 9.33337 25.7891 9.50837 26.6002 9.85837C27.4113 10.2084 28.1168 10.6834 28.7168 11.2834C29.3168 11.8834 29.7918 12.5889 30.1418 13.4C30.4918 14.2112 30.6668 15.0778 30.6668 16C30.6668 16.9223 30.4918 17.7889 30.1418 18.6C29.7918 19.4112 29.3168 20.1167 28.7168 20.7167C28.1168 21.3167 27.4113 21.7917 26.6002 22.1417C25.7891 22.4917 24.9224 22.6667 24.0002 22.6667ZM24.0002 21.3334C25.4891 21.3334 26.7502 20.8167 27.7835 19.7834C28.8168 18.75 29.3335 17.4889 29.3335 16C29.3335 14.5112 28.8168 13.25 27.7835 12.2167C26.7502 11.1834 25.4891 10.6667 24.0002 10.6667C22.5113 10.6667 21.2502 11.1834 20.2168 12.2167C19.1835 13.25 18.6668 14.5112 18.6668 16C18.6668 17.4889 19.1835 18.75 20.2168 19.7834C21.2502 20.8167 22.5113 21.3334 24.0002 21.3334Z" fill="#673DE6"/>
							<path d="M41.1246 20V11.6H44.2326C44.9046 11.6 45.4606 11.712 45.9006 11.936C46.3406 12.16 46.6686 12.468 46.8846 12.86C47.1006 13.252 47.2086 13.692 47.2086 14.18C47.2086 14.644 47.1046 15.072 46.8966 15.464C46.6886 15.848 46.3646 16.16 45.9246 16.4C45.4846 16.632 44.9206 16.748 44.2326 16.748H42.6606V20H41.1246ZM42.6606 15.5H44.1366C44.6726 15.5 45.0566 15.384 45.2886 15.152C45.5286 14.912 45.6486 14.588 45.6486 14.18C45.6486 13.764 45.5286 13.44 45.2886 13.208C45.0566 12.968 44.6726 12.848 44.1366 12.848H42.6606V15.5ZM48.3777 20V11.36H49.9137V20H48.3777ZM53.5351 20.144C53.0231 20.144 52.6031 20.064 52.2751 19.904C51.9471 19.736 51.7031 19.516 51.5431 19.244C51.3831 18.972 51.3031 18.672 51.3031 18.344C51.3031 17.792 51.5191 17.344 51.9511 17C52.3831 16.656 53.0311 16.484 53.8951 16.484H55.4071V16.34C55.4071 15.932 55.2911 15.632 55.0591 15.44C54.8271 15.248 54.5391 15.152 54.1951 15.152C53.8831 15.152 53.6111 15.228 53.3791 15.38C53.1471 15.524 53.0031 15.74 52.9471 16.028H51.4471C51.4871 15.596 51.6311 15.22 51.8791 14.9C52.1351 14.58 52.4631 14.336 52.8631 14.168C53.2631 13.992 53.7111 13.904 54.2071 13.904C55.0551 13.904 55.7231 14.116 56.2111 14.54C56.6991 14.964 56.9431 15.564 56.9431 16.34V20H55.6351L55.4911 19.04C55.3151 19.36 55.0671 19.624 54.7471 19.832C54.4351 20.04 54.0311 20.144 53.5351 20.144ZM53.8831 18.944C54.3231 18.944 54.6631 18.8 54.9031 18.512C55.1511 18.224 55.3071 17.868 55.3711 17.444H54.0631C53.6551 17.444 53.3631 17.52 53.1871 17.672C53.0111 17.816 52.9231 17.996 52.9231 18.212C52.9231 18.444 53.0111 18.624 53.1871 18.752C53.3631 18.88 53.5951 18.944 53.8831 18.944ZM58.9537 22.64L60.3337 19.604H59.9737L57.6577 14.048H59.3257L60.9937 18.236L62.7337 14.048H64.3657L60.5857 22.64H58.9537ZM71.0852 20.144C70.5092 20.144 69.9892 20.012 69.5252 19.748C69.0692 19.484 68.7052 19.12 68.4332 18.656C68.1692 18.184 68.0372 17.64 68.0372 17.024C68.0372 16.408 68.1732 15.868 68.4452 15.404C68.7172 14.932 69.0812 14.564 69.5372 14.3C70.0012 14.036 70.5212 13.904 71.0972 13.904C71.6652 13.904 72.1772 14.036 72.6332 14.3C73.0972 14.564 73.4612 14.932 73.7252 15.404C73.9972 15.868 74.1332 16.408 74.1332 17.024C74.1332 17.64 73.9972 18.184 73.7252 18.656C73.4612 19.12 73.0972 19.484 72.6332 19.748C72.1692 20.012 71.6532 20.144 71.0852 20.144ZM71.0852 18.812C71.4852 18.812 71.8332 18.664 72.1292 18.368C72.4252 18.064 72.5732 17.616 72.5732 17.024C72.5732 16.432 72.4252 15.988 72.1292 15.692C71.8332 15.388 71.4892 15.236 71.0972 15.236C70.6892 15.236 70.3372 15.388 70.0412 15.692C69.7532 15.988 69.6092 16.432 69.6092 17.024C69.6092 17.616 69.7532 18.064 70.0412 18.368C70.3372 18.664 70.6852 18.812 71.0852 18.812ZM75.5066 20V14.048H76.8626L76.9826 15.056C77.1666 14.704 77.4306 14.424 77.7746 14.216C78.1266 14.008 78.5386 13.904 79.0106 13.904C79.7466 13.904 80.3186 14.136 80.7266 14.6C81.1346 15.064 81.3386 15.744 81.3386 16.64V20H79.8026V16.784C79.8026 16.272 79.6986 15.88 79.4906 15.608C79.2826 15.336 78.9586 15.2 78.5186 15.2C78.0866 15.2 77.7306 15.352 77.4506 15.656C77.1786 15.96 77.0426 16.384 77.0426 16.928V20H75.5066ZM87.8747 20V17.012L85.0547 11.6H86.7947L88.6547 15.476L90.5027 11.6H92.2187L89.4107 17.012V20H87.8747ZM94.9563 20.144C94.3803 20.144 93.8603 20.012 93.3963 19.748C92.9403 19.484 92.5763 19.12 92.3043 18.656C92.0403 18.184 91.9083 17.64 91.9083 17.024C91.9083 16.408 92.0443 15.868 92.3163 15.404C92.5883 14.932 92.9523 14.564 93.4083 14.3C93.8723 14.036 94.3923 13.904 94.9683 13.904C95.5363 13.904 96.0483 14.036 96.5043 14.3C96.9683 14.564 97.3323 14.932 97.5963 15.404C97.8683 15.868 98.0043 16.408 98.0043 17.024C98.0043 17.64 97.8683 18.184 97.5963 18.656C97.3323 19.12 96.9683 19.484 96.5043 19.748C96.0403 20.012 95.5243 20.144 94.9563 20.144ZM94.9563 18.812C95.3563 18.812 95.7043 18.664 96.0003 18.368C96.2963 18.064 96.4443 17.616 96.4443 17.024C96.4443 16.432 96.2963 15.988 96.0003 15.692C95.7043 15.388 95.3603 15.236 94.9683 15.236C94.5603 15.236 94.2083 15.388 93.9123 15.692C93.6243 15.988 93.4803 16.432 93.4803 17.024C93.4803 17.616 93.6243 18.064 93.9123 18.368C94.2083 18.664 94.5563 18.812 94.9563 18.812ZM101.61 20.144C100.866 20.144 100.29 19.912 99.8817 19.448C99.4817 18.984 99.2817 18.304 99.2817 17.408V14.048H100.806V17.264C100.806 17.776 100.91 18.168 101.118 18.44C101.326 18.712 101.654 18.848 102.102 18.848C102.526 18.848 102.874 18.696 103.146 18.392C103.426 18.088 103.566 17.664 103.566 17.12V14.048H105.102V20H103.746L103.626 18.992C103.442 19.344 103.174 19.624 102.822 19.832C102.478 20.04 102.074 20.144 101.61 20.144ZM108.67 20V12.836H106.222V11.6H112.666V12.836H110.206V20H108.67ZM115.403 20.144C114.659 20.144 114.083 19.912 113.675 19.448C113.275 18.984 113.075 18.304 113.075 17.408V14.048H114.599V17.264C114.599 17.776 114.703 18.168 114.911 18.44C115.119 18.712 115.447 18.848 115.895 18.848C116.319 18.848 116.667 18.696 116.939 18.392C117.219 18.088 117.359 17.664 117.359 17.12V14.048H118.895V20H117.539L117.419 18.992C117.235 19.344 116.967 19.624 116.615 19.832C116.271 20.04 115.867 20.144 115.403 20.144ZM123.999 20.144C123.551 20.144 123.159 20.06 122.823 19.892C122.487 19.724 122.215 19.488 122.007 19.184L121.839 20H120.471V11.36H122.007V14.9C122.199 14.636 122.451 14.404 122.763 14.204C123.083 14.004 123.495 13.904 123.999 13.904C124.559 13.904 125.059 14.04 125.499 14.312C125.939 14.584 126.287 14.956 126.543 15.428C126.799 15.9 126.927 16.436 126.927 17.036C126.927 17.636 126.799 18.172 126.543 18.644C126.287 19.108 125.939 19.476 125.499 19.748C125.059 20.012 124.559 20.144 123.999 20.144ZM123.675 18.8C124.163 18.8 124.567 18.636 124.887 18.308C125.207 17.98 125.367 17.556 125.367 17.036C125.367 16.516 125.207 16.088 124.887 15.752C124.567 15.416 124.163 15.248 123.675 15.248C123.179 15.248 122.771 15.416 122.451 15.752C122.139 16.08 121.983 16.504 121.983 17.024C121.983 17.544 122.139 17.972 122.451 18.308C122.771 18.636 123.179 18.8 123.675 18.8ZM131.192 20.144C130.592 20.144 130.06 20.016 129.596 19.76C129.132 19.504 128.768 19.144 128.504 18.68C128.24 18.216 128.108 17.68 128.108 17.072C128.108 16.456 128.236 15.908 128.492 15.428C128.756 14.948 129.116 14.576 129.572 14.312C130.036 14.04 130.58 13.904 131.204 13.904C131.788 13.904 132.304 14.032 132.752 14.288C133.2 14.544 133.548 14.896 133.796 15.344C134.052 15.784 134.18 16.276 134.18 16.82C134.18 16.908 134.176 17 134.168 17.096C134.168 17.192 134.164 17.292 134.156 17.396H129.632C129.664 17.86 129.824 18.224 130.112 18.488C130.408 18.752 130.764 18.884 131.18 18.884C131.492 18.884 131.752 18.816 131.96 18.68C132.176 18.536 132.336 18.352 132.44 18.128H134C133.888 18.504 133.7 18.848 133.436 19.16C133.18 19.464 132.86 19.704 132.476 19.88C132.1 20.056 131.672 20.144 131.192 20.144ZM131.204 15.152C130.828 15.152 130.496 15.26 130.208 15.476C129.92 15.684 129.736 16.004 129.656 16.436H132.62C132.596 16.044 132.452 15.732 132.188 15.5C131.924 15.268 131.596 15.152 131.204 15.152Z" fill="#673DE6"/>
							<rect x="0.5" y="0.5" width="150" height="31" rx="3.5" stroke="#DADCE0"/>
						</svg>
					</a>
				</div>
			</div>
		</div>
		<?php return ob_get_clean();
	}

	public function step_identifier(): string {
		return 'connect_domain';
	}
	public function get_redirect_link(): string {
		$site_url = preg_replace( '#^https?://#', '', get_site_url() );
		$hpanel_url = self::HOSTINGER_ADD_DOMAIN_URL . $site_url . '/options';

		$query_parameters = array(
			'websiteType' => 'wordpress',
			'redirectUrl' => self::HOSTINGER_WEBSITES_URL,
		);

		$url = $hpanel_url . '?' . http_build_query($query_parameters);

		return $url;
	}

	public function button_text(): string {
		return __( 'Connect domain now', 'hostinger' );
	}

}
